<?php

namespace Import\ApiBundle\Entity;

use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\ORM\Mapping as ORM;

/**
 * AllegroCategory
 *
 * @Gedmo\Tree(type="nested")
 * @ORM\Table(name="allegro_category")
 * use repository for handy tree functions
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\AllegroCategoryRepository")
 */
class AllegroCategory
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string $title
     *
     * @ORM\Column(name="title", type="string", length=64)
     */
    private $title;

    /**
     * @var string $cat_id
     *
     * @ORM\Column(name="cat_id", type="integer")
     */
    private $cat_id;

    /**
     * @Gedmo\TreeLeft
     * @ORM\Column(name="lft", type="integer")
     */
    private $lft;

    /**
     * @Gedmo\TreeLevel
     * @ORM\Column(name="lvl", type="integer")
     */
    private $lvl;

    /**
     * @Gedmo\TreeRight
     * @ORM\Column(name="rgt", type="integer")
     */
    private $rgt;

    /**
     * @Gedmo\TreeRoot
     * @ORM\Column(name="root", type="integer", nullable=true)
     */
    private $root;

    /**
     * @Gedmo\TreeParent
     * @ORM\ManyToOne(targetEntity="AllegroCategory", inversedBy="children")
     * @ORM\JoinColumn(name="parent_id", referencedColumnName="id", onDelete="CASCADE")
     */
    private $parent;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategory", mappedBy="parent")
     * @ORM\OrderBy({"lft" = "ASC"})
     */
    private $children;

    /**
     * @ORM\OneToMany(targetEntity="AllegroCategoryItem", mappedBy="category")
     */
    private $items;

    public function getId()
    {
        return $this->id;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setCatId($catId)
    {
        $this->cat_id = $catId;
    }

    public function getCatId()
    {
        return $this->cat_id;
    }

    public function getLvl()
    {
        return $this->lvl;
    }

    public function setParent(AllegroCategory $parent = null)
    {
        $this->parent = $parent;
    }

    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Add items
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $items
     * @return AllegroCategory
     */
    public function addItem(\Import\ApiBundle\Entity\AllegroCategoryItem $items)
    {
        $this->items[] = $items;

        return $this;
    }

    /**
     * Remove items
     *
     * @param \Import\ApiBundle\Entity\AllegroCategoryItem $items
     */
    public function removeItem(\Import\ApiBundle\Entity\AllegroCategoryItem $items)
    {
        $this->items->removeElement($items);
    }

    /**
     * Get items
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getItems()
    {
        return $this->items;
    }
}